<?php
// --- Pieslēdzam datubāzes savienojumu ---
include 'con.php';

// --- Inicializējam mainīgos (lai izvairītos no kļūdām, ja kaut kas nav padots) ---
$vehicle1 = $vehicle2 = $vehicle3 = $fname = $lname = $cars = $fav_language = "";
$date = "";

// --- Atļaujam saņemt datus gan ar POST, gan GET (atkarībā no formas nosūtīšanas veida) ---
$input = $_SERVER["REQUEST_METHOD"] === "POST" ? $_POST : $_GET;

// --- Droši iegūstam datus ar pārbaudi (ja lauks nav padots, atgriež tukšu virkni) ---
$fname        = $input["fname"]        ?? "";
$lname        = $input["lname"]        ?? "";
$date         = $input["date"]         ?? "";
$cars         = $input["cars"]         ?? "";
$vehicle1     = $input["vehicle1"]     ?? "";
$vehicle2     = $input["vehicle2"]     ?? "";
$vehicle3     = $input["vehicle3"]     ?? "";
$fav_language = $input["fav_language"] ?? "";
$id           = $input["id"]           ?? "";


// --- Pārbaudām, vai obligātie lauki ir aizpildīti ---
if (empty($fname) || empty($lname) || empty($cars) || empty($date)) {
    echo "Kļūda: Visi obligātie lauki (vārds, uzvārds, auto, datums) ir jāaizpilda!";
    exit;
}

// --- Pārbaudām, vai datuma formāts ir pareizs ---
if (!preg_match("/^\d{4}-\d{2}-\d{2}$/", $date)) {
    echo "Kļūda: Datuma formāts nav korekts!";
    exit;
}

// --- Pārbaudām, vai datums nav '0000-00-00' vai tukšs ---
if ($date === "0000-00-00" || $date === "") {
    echo "Kļūda: Nederīgs datums!";
    exit;
}


// --- Ja "id" ir tukšs, tad ievietojam jaunu ierakstu ---
if ($id === "") {
    $sql = "INSERT INTO `Table1`
            (`vards`, `uzvards`, `dati`, `car`, `transports1`, `transports2`, `transports3`, `prvalodas`)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssssss", $fname, $lname, $date, $cars, $vehicle1, $vehicle2, $vehicle3, $fav_language);
} else {
    // --- Ja "id" eksistē, tad atjaunojam esošu ierakstu ---
    $sql = "UPDATE `Table1` SET 
                `vards`=?, `uzvards`=?, `dati`=?, `car`=?, 
                `transports1`=?, `transports2`=?, `transports3`=?, `prvalodas`=?
            WHERE id=?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssssssi", $fname, $lname, $date, $cars, $vehicle1, $vehicle2, $vehicle3, $fav_language, $id);
}


if ($stmt->execute()) {
    echo "Dati veiksmīgi saglabāti!<br>";
    echo "Vārds: " . htmlspecialchars($fname) . "<br>";
    echo "Uzvārds: " . htmlspecialchars($lname) . "<br>";
    echo "Datums: " . htmlspecialchars($date) . "<br>";
    echo "Auto: " . htmlspecialchars($cars) . "<br>";
} else {
    echo "Kļūda saglabājot datus: " . htmlspecialchars($stmt->error);
}

// --- Atbrīvo resursus un aizver savienojumu ---
$stmt->close();
$conn->close();
?>
